<?php
function resize2($img, $w, $h, $newfilename) {
		
	//Check if GD extension is loaded
	if (!extension_loaded('gd') && !extension_loaded('gd2')) {
		trigger_error("GD is not loaded", E_USER_WARNING);
		return false;
	}
 
	//Get Image size info
	$imgInfo = getimagesize($img);
	
	switch ($imgInfo[2]) {
		
		case 1: $im = imagecreatefromgif($img); break;
		case 2: $im = imagecreatefromjpeg($img); break;
		case 3: $im = imagecreatefrompng($img); break;
				
		default:  trigger_error('Unsupported filetype!', E_USER_WARNING);  break;
		
	}
 
	//If image dimension is smaller, do not resize
	if ($imgInfo[0] <= $w && $imgInfo[1] <= $h) {
		$nHeight = $imgInfo[1];
  		$nWidth = $imgInfo[0];
 	} else {
		//yeah, resize it, but keep it proportional
		if ($w/$imgInfo[0] > $h/$imgInfo[1]) {
			$nWidth = $w;
			$nHeight = $imgInfo[1]*($w/$imgInfo[0]);
		}else{
			$nWidth = $imgInfo[0]*($h/$imgInfo[1]);
			 $nHeight = $h;
		}
 	}
	
	$nWidth = round($nWidth);
 	$nHeight = round($nHeight);
 
 	$newImg = imagecreatetruecolor($nWidth, $nHeight);
 
	/* Check if this image is PNG or GIF, then set if Transparent*/  
	if(($imgInfo[2] == 1) OR ($imgInfo[2]==3)){
		imagealphablending($newImg, false);
	  	imagesavealpha($newImg,true);
	  	$transparent = imagecolorallocatealpha($newImg, 255, 255, 255, 127);
	  	imagefilledrectangle($newImg, 0, 0, $nWidth, $nHeight, $transparent);
	}
	
	imagecopyresampled($newImg, $im, 0, 0, 0, 0, $nWidth, $nHeight, $imgInfo[0], $imgInfo[1]);
 
	//Generate the file, and rename it to $newfilename
	switch ($imgInfo[2]) {
		case 1: imagegif($newImg,$newfilename); break;
		case 2: imagejpeg($newImg,$newfilename);  break;
		case 3: imagepng($newImg,$newfilename); break;
		default:  trigger_error('Failed resize image!', E_USER_WARNING);  break;
	}
   
  
   return $newfilename;
}
function resize($Image, $Img_Dir, $width, $height, $mod_name = '', $target_dir = '') {
	$ext = substr(strrchr($Image, '.'), 1);
	$ext = strtoupper($ext);
	
	if($ext != "JPG" && $ext != "JPEG" && $ext != "GIF" && $ext != "PNG") {
		$_SESSION['Message'] = "Only .jpg, .jpeg, .gif and .png are supported";
		return FALSE;
	}
	$sourcefile = $Img_Dir . $Image;          
	if($target_dir != '') {
		$targetfile = $target_dir . $mod_name . $Image;
	} else {
		$targetfile = $Img_Dir . $mod_name . $Image;
	}
	$imagesize = getimagesize("$sourcefile");
	if($imagesize[0] > $width || $imagesize[1] > $width) {
		if ($imagesize[0] > $imagesize[1]) {
			$percentage = ($width / $imagesize[0]);
		} else {
			$percentage = ($height / $imagesize[1]);
		}
		
		$new_width = round($imagesize[0] * $percentage);
		$new_height = round($imagesize[1] * $percentage);
		$dest_x = $new_width;
		$dest_y = $new_height;
		$jpegqual = 100;
		switch($ext){
			case 'JPG' :
			case 'JPEG' :
			$source_id = imageCreatefromjpeg("$sourcefile");
			break;
			case 'GIF' :
			$source_id = imageCreatefromgif("$sourcefile");
			break;
			case 'PNG' :
			$source_id = imageCreatefrompng("$sourcefile");
			break;
		}
		
		$target_id = imagecreatetruecolor($dest_x, $dest_y);
		$target_pic = imagecopyresampled ($target_id,$source_id,0,0,0,0,$dest_x,$dest_y,$imagesize[0],$imagesize[1]);
		imagejpeg ($target_id,"$targetfile",$jpegqual);
	} else {
		@copy($sourcefile, $targetfile);
	}
	return TRUE;
}
/* Function to resize an Image */
/*
function resize($Image, $Img_Dir, $width, $height, $mod_name = '', $target_dir = '') {
	$ext = substr(strrchr($Image, '.'), 1);
	$ext = strtoupper($ext);
	if($ext != "JPG" && $ext != "JPEG" && $ext != "GIF" && $ext != "PNG") {
		$_SESSION['Message'] = "Only .jpg, .jpeg, .gif and .png are supported";
		return FALSE;
	}
	$sourcefile = $Img_Dir . $Image;          
	if($target_dir != '') {
		$targetfile = $target_dir . $mod_name . $Image;
	} else {
		$targetfile = $Img_Dir . $mod_name . $Image;
	}
	$imagesize = getimagesize("$sourcefile");
	if($imagesize[0] > $width || $imagesize[1] > $width) {
		if ($imagesize[0] > $imagesize[1]) {
			$percentage = ($width / $imagesize[0]);
		} else {
			$percentage = ($height / $imagesize[1]);
		}
		$new_width = round($imagesize[0] * $percentage);
		$new_height = round($imagesize[1] * $percentage);
		$dest_x = $new_width;
		$dest_y = $new_height;
		$jpegqual = 100;
		switch($ext){
			case 'JPG' :
			case 'JPEG' :
			$source_id = imageCreatefromjpeg("$sourcefile");
			break;
			case 'GIF' :
			$source_id = imageCreatefromgif("$sourcefile");
			break;
			case 'PNG' :
			$source_id = imageCreatefrompng("$sourcefile");
			break;
		}
		$target_id = imagecreatetruecolor($dest_x, $dest_y);
		$target_pic = imagecopyresampled ($target_id,$source_id,0,0,0,0,$dest_x,$dest_y,$imagesize[0],$imagesize[1]);
		imagejpeg ($target_id,"$targetfile",$jpegqual);
	} else {
		@copy($sourcefile, $targetfile);
	}
	return TRUE;
}
*/
//function to add watermark

function createwatermark ($imageLoc, $id) {
	//USE GIF IMAGES (for watermark)
	$getCatQry = "SELECT photo FROM tbl_category WHERE c_id = $id";
	$execCatQry = mysqli_query($con, $getCatQry);
	$resCatQry = mysqli_fetch_array($execCatQry);
	$cid = $resCatQry['photo'];
	
	$waterLoc = CAT_IMG_FOLDER . $cid;
	$size = getimagesize($imageLoc);
	$image_height = $size[1];
	$image_width = $size[0];
	
	$wextn = substr(strrchr($waterLoc, '.'), 1);
	if(($wextn == 'gif') || ($wextn == 'GIF')){
		$watermark = imagecreatefromgif($waterLoc);
	}
	if(($wextn == 'jpg') || ($wextn == 'JPG')){
		$watermark = imagecreatefromjpeg($waterLoc);
	}
	if(($wextn == 'png') || ($wextn == 'PNG')){
		$watermark = imagecreatefrompng($waterLoc);
	}
	$watermark_width = imagesx($watermark);
	$watermark_height = imagesy($watermark);	
	
	$image = imagecreatetruecolor($watermark_width, $watermark_height);
	$extn = substr(strrchr($imageLoc, '.'), 1);
	if(($extn =='gif') || ($extn =='GIF')){
		$image = imagecreatefromgif($imageLoc );
	}
	if(($extn =='jpg') || ($extn =='JPG')){
		$image = imagecreatefromjpeg($imageLoc );
	}
	if(($extn =='png') || ($extn =='PNG')){
		$image = imagecreatefrompng($imageLoc );
	}
	
	
	$size = getimagesize($imageLoc);
	$dest_y = $image_height -$watermark_height;
	$dest_x = 0;
	imagecopymerge($image, $watermark, $dest_x, $dest_y, 0, 0, $watermark_width, $watermark_height, 100);
	if(($extn =='gif') || ($extn =='GIF')){
		$newImage = imagegif($image, $imageLoc);
	}
	if(($extn =='jpg') || ($extn =='JPG')){
		$newImage = imagejpeg($image, $imageLoc);
	}
	if(($extn =='png') || ($extn =='PNG')){
		$newImage = imagepng($image, $imageLoc);
	}
	
	return $newImage;
}


// edited rsize function
function re_size($img, $w, $h, $newfilename) {
		
	//Check if GD extension is loaded
	if (!extension_loaded('gd') && !extension_loaded('gd2')) {
		trigger_error("GD is not loaded", E_USER_WARNING);
		return false;
	}
 
	//Get Image size info
	$imgInfo = getimagesize($img);
	
	switch ($imgInfo[2]) {
		
		case 1: $im = imagecreatefromgif($img); break;
		case 2: $im = imagecreatefromjpeg($img); break;
		case 3: $im = imagecreatefrompng($img); break;
				
		default:  trigger_error('Unsupported filetype!', E_USER_WARNING);  break;
		
	}
 
	//If image dimension is smaller, do not resize
	if ($imgInfo[0] <= $w && $imgInfo[1] <= $h) {
		$nHeight = $imgInfo[1];
  		$nWidth = $imgInfo[0];
 	} else {
		//yeah, resize it, but keep it proportional
		if ($w/$imgInfo[0] > $h/$imgInfo[1]) {
			$nWidth = $w;
			$nHeight = $imgInfo[1]*($w/$imgInfo[0]);
		}else{
			$nWidth = $imgInfo[0]*($h/$imgInfo[1]);
			 $nHeight = $h;
		}
 	}
	
	$nWidth = round($nWidth);
 	$nHeight = round($nHeight);
 
 	$newImg = imagecreatetruecolor($nWidth, $nHeight);
 
	/* Check if this image is PNG or GIF, then set if Transparent*/  
	if(($imgInfo[2] == 1) OR ($imgInfo[2]==3)){
		imagealphablending($newImg, false);
	  	imagesavealpha($newImg,true);
	  	$transparent = imagecolorallocatealpha($newImg, 255, 255, 255, 127);
	  	imagefilledrectangle($newImg, 0, 0, $nWidth, $nHeight, $transparent);
	}
	
	imagecopyresampled($newImg, $im, 0, 0, 0, 0, $nWidth, $nHeight, $imgInfo[0], $imgInfo[1]);
 
	//Generate the file, and rename it to $newfilename
	switch ($imgInfo[2]) {
		case 1: imagegif($newImg,$newfilename); break;
		case 2: imagejpeg($newImg,$newfilename);  break;
		case 3: imagepng($newImg,$newfilename); break;
		default:  trigger_error('Failed resize image!', E_USER_WARNING);  break;
	}
   
  
   return $newfilename;
}
?>